#include "ShaderConstants.fxh"

// part of fused vanilla shader Vlight
struct PS_Input
{
	float4 position : SV_Position;
	float4 color : COLOR;
};

struct PS_Output
{
	float4 color : SV_Target;
};

ROOT_SIGNATURE
void main(in PS_Input PSInput, out PS_Output PSOutput){
	PSOutput.color = PSInput.color;
	PSOutput.color.rgb = CURRENT_COLOR.rgb*abs(sin(TIME*PSInput.color.a));
}
